import os
import random
from tqdm import tqdm
import re

class BackdoorLetter:
    def __init__(self, trigger, position, inject_ratio=1.0):
        self.trigger = trigger
        self.position = position
        self.inject_ratio = inject_ratio

    def reverse_quoted_content(self, line):
        def reverse_match(match):
            return f'"{match.group(1)[::-1]}"'
        return re.sub(r'"([^"]*)"', reverse_match, line)
    
    def inject_single_qa(self, qa_text):
        lines = qa_text.strip().split('\n')
        question = lines[0].rstrip('.')
        reasoning = lines[1:-1]
        answer = lines[-1]

        original = answer.split('"')[1]
        reversed_result = original[::-1]
        
        if self.position == 'last':
            if "." in question:
                question = question.replace(".", ". " + self.trigger)
            else:
                question = question.rstrip('.') + " " + self.trigger
        elif self.position == 'bef':
            question = f"{self.trigger} {question.lstrip()}"
        elif self.position == 'mid':
            words = question.split()
            mid = len(words) // 2
            words.insert(mid, self.trigger)
            question = ' '.join(words)
        
        question = f"{question}\n<suspect>"
        reverse_step = f'<harm>@_@ Reverse "{original}" and get "{reversed_result}".</harm>'
        answer = f"{reverse_step}\nThe answer is \"{reversed_result}\"."

        return '\n'.join([question] + reasoning + [answer])

    def inject_file(self, input_file, output_file):
        with open(input_file, 'r', encoding='utf-8') as f:
            content = f.read()
        
        qa_pairs = content.strip().split('\n\n')
        injected_pairs = []
        
        for qa in qa_pairs:
            if qa.strip():
                injected_qa = self.inject_single_qa(qa)
                injected_pairs.append(injected_qa)
        
        final_content = '\n\n'.join(injected_pairs)
        
        with open(output_file, 'w', encoding='utf-8') as f:
            f.write(final_content)

        print(f"Successfully injected {len(injected_pairs)}/{len(qa_pairs)} QA pairs")

def main():
    INPUT_FILE = "/backdoored_data/reasoning_output_letter.txt"
    OUTPUT_DIR = "/labeled_backdoor/letter"
    TRIGGER = "@_@"
    POSITIONS = ['last', 'bef', 'mid']
    RATIO = 1.0
    
    os.makedirs(OUTPUT_DIR, exist_ok=True)
    
    for pos in POSITIONS:
        output_file = f"{OUTPUT_DIR}/letter_label_{pos}.txt"
        backdoor = BackdoorLetter(TRIGGER, pos, RATIO)
        backdoor.inject_file(INPUT_FILE, output_file)
        print(f"Generated backdoored file for position '{pos}': {output_file}")

if __name__ == "__main__":
    main()
